#include <cellstatus.h>
#include "UnityNP.h"

//	The name of the native plug
SYS_MODULE_INFO( UnityNpToolkit, 0, 1, 1);

//	This gets called on entry (after global constructors)
SYS_MODULE_START( UnityNPToolkitStart );

//	Called to stop the module
SYS_MODULE_STOP( UnityNPToolkitStop );

SYS_MODULE_EXIT( UnityNPToolkitStop );

//	We need a stub library for Unity
SYS_LIB_DECLARE_WITH_STUB( UnityNpToolkit, SYS_LIB_AUTO_EXPORT, UnityNPToolkit_stub );

PRX_EXPORT int UnityNPToolkitStart(unsigned int args, void* argp)
{
	gAppInfo = *(PrxPluginArgs*)argp;

	printf("Size = %d\n",gAppInfo.m_Size);
	printf("Version = %d\n",gAppInfo.m_Version);
	SceNpCommunicationId*			commID = (SceNpCommunicationId*)gAppInfo.m_NpCommunicationId;
	printf("CommID = %s\n",commID->data);
//	printf("CommSig = %s\n",gAppInfo.m_NpCommunicationSignature->data);			// Array, not string
//	printf("CommPassPhrase = %s\n",gAppInfo.m_NpCommunicationPassphrase->data); // Array, not string
	if( gAppInfo.m_NpHasTrophyPack )
		printf("Has Trophies = TRUE\n");
	else
		printf("Has Trophies = FALSE\n");
	printf("ServiceID = %s\n",gAppInfo.m_NpServiceID);
	printf("TitleID = %s\n",gAppInfo.m_TitleID);
	printf("Age Rating = %d\n",gAppInfo.m_NpAgeRating);
	if( gAppInfo.m_Trial )
		printf("Trial Mode = TRUE\n");
	else
		printf("Trial Mode = FALSE\n");
	printf("SPURS Instance Address = %p\n",gAppInfo.m_SpursInstance);
	printf("Development Build = %d\n",gAppInfo.m_bDevelopment);
	int	ret = SYS_PRX_RESIDENT;

	//	Check for size of args
	if(gAppInfo.m_Size != sizeof(PrxPluginArgs))
	{
		printf("ERROR: PrxPluginArgs - Incorrect Size Member, expected %d, found %d\n", sizeof(PrxPluginArgs), gAppInfo.m_Size);
	}

	//	Check for version of args
	if(gAppInfo.m_Version != PrxPluginArgs::s_Version)
	{
		printf("ERROR: PrxPluginArgs - Version Mismatch, found %04x, expected %04x\n", gAppInfo.m_Version, gAppInfo.s_Version);
	}

    return ret;
}

PRX_EXPORT int UnityNPToolkitStop(unsigned int args, void* argp)
{
	(void) args;
	(void) argp;
    return 1;
}

//	 Test functions
DO_EXPORT(int,  _UnityNpToolkit_export_function )(void)
{
    return CELL_OK;
}
DO_EXPORT (int, _UnityNpToolkit_export_function2) (void)
{
	return 101;	//	Just a test function - has no significance...:-)
}

// Address undefined reference to `__cxa_pure_virtual' issue
extern "C" int __cxa_pure_virtual()
{
	return 0;
}

//	-----------------------------------------------------------------------------------------------------
//	These are from Sony's NP Toolkit Sample
const SceNpCommunicationId s_np_communication_id = {
	{'N', 'P', 'W', 'R', '0', '1', '8', '4', '4'},
	'\0',
	0,
	0
};

SceNpCommunicationPassphrase s_np_com_passphrase = {
	{
			0x7c,0x2d,0xaa,0x2b,0x7d,0x6e,0x52,0x19,
			0x4a,0x64,0x0a,0x25,0x52,0xb2,0x78,0x1b,
			0xae,0x3d,0xf9,0xa6,0xd7,0xb0,0x6f,0x69,
			0xfb,0x8b,0x0a,0x4b,0xa6,0x36,0x13,0x3f,
			0x5e,0x4e,0x0d,0x65,0xfd,0x53,0x0f,0xd5,
			0xb3,0x45,0x58,0x7f,0x11,0x87,0xed,0x8b,
			0x50,0x19,0xa3,0x0d,0xd8,0xab,0x51,0x03,
			0xce,0x74,0xee,0xbf,0x74,0x52,0x8d,0x6d,
			0x8a,0x11,0x7f,0x64,0x95,0x05,0xaf,0x3b,
			0xe5,0xcf,0x6a,0xe1,0xbb,0xd6,0x2e,0x76,
			0xec,0x16,0x81,0x5d,0x21,0x9f,0x93,0xae,
			0xaa,0x43,0xb3,0xce,0x10,0x2f,0xee,0xf8,
			0xc9,0xc8,0x27,0xfb,0x60,0x90,0xfc,0x31,
			0x0a,0x39,0xa1,0x96,0x53,0x2e,0x1a,0xcf,
			0xf4,0x01,0xa5,0xa1,0xab,0xb5,0x44,0xb7,
			0xfd,0xbf,0xda,0x83,0x4d,0x3e,0x5b,0xdb
	}
};

const SceNpCommunicationSignature s_npcommsign = {
	{
			0xb9,0xdd,0xe1,0x3b,0x01,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0xba,0x14,0x53,0xd9,
			0xc3,0x2d,0x1a,0x18,0x84,0x94,0x1a,0x13,
			0xf4,0x03,0x53,0xc6,0x03,0x98,0x43,0x57,
			0x01,0x3e,0xfa,0xb5,0x5c,0x1e,0xf2,0x1c,
			0x67,0x6e,0x8c,0x41,0x87,0x60,0x03,0xa9,
			0xca,0xdc,0x1d,0x67,0xcc,0x0c,0x7c,0x4e,
			0x74,0x37,0x4d,0x26,0xd7,0x56,0xf9,0x36,
			0x45,0xba,0x83,0x32,0xcf,0x8e,0x3f,0xd7,
			0xb1,0xcb,0x91,0xdd,0xd2,0xf4,0x5b,0xe4,
			0xc6,0xf6,0x10,0x91,0x5d,0x62,0x9d,0x20,
			0x6b,0x91,0x83,0x43,0x41,0xbd,0x53,0xc8,
			0xac,0x5e,0x90,0xc8,0xc2,0x7d,0x1e,0x3d,
			0x3c,0xaf,0x77,0x39,0x20,0xd5,0xe8,0x6d,
			0xe1,0xbd,0xbc,0xf4,0x41,0x92,0xdd,0x6f,
			0xe7,0x54,0xc6,0xe8,0x50,0xd4,0x08,0x16,
			0x9d,0xa1,0x76,0xba,0x7c,0x2e,0xee,0xb7,
			0x8d,0x08,0xad,0xb8,0x90,0xba,0xce,0x16,
			0xdc,0x5e,0x66,0x39,0x70,0x60,0x49,0xb6,
			0x05,0x24,0x47,0xd0,0x65,0xdc,0x1f,0xd7
	}
};

const std::string s_serviceId = "ED1987-NPXX00877_00";
//	-----------------------------------------------------------------------------------------------------
